/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;

public class OffsetLocator
extends AbstractLocator {
    private static final long serialVersionUID = 2679950024611847621L;
    private int offsetLocatorSerializedDataVersion = 1;
    private Locator fBase = null;
    private int fOffsetX = 0;
    private int fOffsetY = 0;

    public OffsetLocator() {
    }

    public OffsetLocator(Locator base) {
        this();
        this.fBase = base;
    }

    public OffsetLocator(Locator base, int offsetX, int offsetY) {
        this(base);
        this.fOffsetX = offsetX;
        this.fOffsetY = offsetY;
    }

    public Point locate(Figure owner) {
        Point p = this.fBase.locate(owner);
        p.x += this.fOffsetX;
        p.y += this.fOffsetY;
        return p;
    }

    public void moveBy(int dx, int dy) {
        this.fOffsetX += dx;
        this.fOffsetY += dy;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fOffsetX = dr.readInt();
        this.fOffsetY = dr.readInt();
        this.fBase = (Locator)dr.readStorable();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fOffsetX);
        dw.writeInt(this.fOffsetY);
        dw.writeStorable(this.fBase);
    }

    public Dimension getOffset() {
        return new Dimension(this.fOffsetX, this.fOffsetY);
    }

    public Locator getBaseLocator() {
        return this.fBase;
    }

    public void setOffset(int xOffset, int yOffset) {
        this.fOffsetX = xOffset;
        this.fOffsetY = yOffset;
    }
}

